import requestModule from './reservation-request.js'
const {
  api
} = requestModule

/**
 * 获取手机号
 * @returns
 * @param {string} memberId 用户memberId
 * @param {string} code 微信code
 */
export const decodePhone = (data) => api.post('/decode_phone', data)

/**
 * 获取日期
 * @returns
 * @param {string} memberId 用户memberId
 */
export const getDateConfig = (data) => api.post('/get_day', data)

/**
 * 获取时间
 * @returns
 * @param {string} memberId 用户memberId
 * @param {string} day 日期
 */
export const getTimeConfig = (data) => api.post('/get_time', data)

/**
 * 获取工厂
 * @returns
 * @param {string} memberId 用户memberId
 */
export const getGround = (data) => api.post('/get_ground', data)


/**
 * 预约列表
 * @returns
 * @param {string} memberId 用户memberId
 */
export const reservationList = (data) => api.post('/reservation_list', data)

/**
 * 预约详情
 * @returns
 * @param {string} id 预约id
 */
export const reservationDetail = (data) =>
  api.post('/reservation_detail', data)

/**
 * 取消预约
 * @returns
 * @param {string} id 预约id
 */
export const reservationCancel = (data) =>
  api.post('/reservation_cancel', data)

/**
 * 发起预约
 * @returns
 * @param {string} data.memberId 用户memberId
 * @param {string} data.reservation_date 预约日期
 * @param {string} data.reservation_time 预约时间
 * @param {string} data.realname 预约人姓名
 * @param {string} data.telephone 预约人手机号
 * @param {string} data.visitor_number 访客人数
 * @param {string} data.type 访客类型
 */
export const reservation = (data) => api.post('/reservation', data)

export const linkmember = (data) => api.post('/linkmember', data)
