import requestModule from './request.js';
const { api } = requestModule;

/**
 * 获取积分信息
 * @returns
 */

export const fetchIntegralJSON = (type = 'integral_V1') => api.get('/c/front/content', { type });

/**
 * 获取生日礼接口
 * @returns
 */
export const fetchBirthdayGiftJSON = () => api.get('/c/equity/birthdayGift/index');

/**
 * 领取生日礼
 * @returns
 */
export const fetchBatchReceiveJSON = () => api.post('/c/equity/birthdayGift/batchReceive');

/**
 * 获取活动状态--溯源游
 * @returns
 */
export const fetchActivityStateJSON = () => api.get('/c/third/activity/state');

//获取配置项和商品列表
export const getResourceList = () => api.get('/c/resource/list');

//获取签到和任务信息接口
export const getSigninAndTaskInfoJSON = () => api.get('/c/activity/todo/list', { mockTime:Date.now() });

//签到接口
export const checkInJSON = (activityId) => api.post('/c/activity/todo/checkIn', { activityId, mockTime:Date.now() });

//获取秒杀列表
export const getSeckillList = () => api.get('/c/seckill/list');
//完成任务接口
export const taskCompleteJSON = (activityId) => api.post('/c/activity/todo/complete', { activityId, mockTime:Date.now() });

//接收任务接口
export const taskReceiveJSON = (activityId) => api.post('/c/activity/todo/receive', { activityId, mockTime:Date.now()});

//获取异业券接口
export const getPointsBenefitCouponJSON = (type) => api.get('/c/resource/pointsBenefit/coupon', { type });

//查询任务结果接口
export const queryTodoResultJSON = (activityId) => api.get('/c/activity/todo/queryTodoResult');

//获取邀请活动首页信息接口
export const getOriginInviteHomeJSON = () => api.get('/c/activity/origin_invite/home');

//邀请助力接口
export const assistInviteJSON = (invitationCode, wxUnionId) =>
  api.post('/c/activity/origin_invite/assist', {
    invitationCode,
    wxUnionId,
  });

//获取邀请记录列表接口
export const getInvitationListJSON = () => api.get('/c/activity/origin_invite/invitationList');

//邀请绑定接口
export const originInviteBindJSON = (unionId, shareCode) =>
  api.post('/c/api/activity/originInviteBind', {
    unionId,
    shareCode,
  });
