# H5投放参数使用文档

## 概述

本文档说明如何在小程序中跳转到H5页面（webview），以及如何传递参数给H5页面。

## 页面路径

小程序webview页面路径：`/pages/gameWebview/webview`

## URL参数说明

### 基础参数

| 参数名 | 类型 | 必填 | 说明 | 示例 |
|--------|------|------|------|------|
| `url` | String | 否 | H5页面URL（完整URL或相对路径） | `https://example.com/h5/page` |
| `baseUrl` | String | 否 | 同 `url`，用于指定H5页面URL | `https://example.com/h5/page` |
| `scene` | String | 否 | 二维码场景值（会自动双重解码） | `?type=activity&id=123` |
| `needLogin` | String | 否 | 是否需要登录（`'true'` 或 `'false'`） | `'true'` |

**注意**：
- `url` 和 `baseUrl` 参数互斥，两者功能相同，优先使用 `url`
- 如果 `url` 或 `baseUrl` 不包含协议（`http://` 或 `https://`），会自动添加 `https://`
- 如果未指定 `url` 或 `baseUrl`，默认使用：`https://momclub-test.feihe.com/h5/game/index.html`

### 自定义参数

除了上述基础参数外，其他所有参数都会原样传递给H5页面。

**示例**：
```javascript
uni.navigateTo({
  url: '/pages/gameWebview/webview?url=https://example.com/h5/page&activityId=123&type=game&source=wechat'
})
```

H5页面接收到的URL为：
```
https://example.com/h5/page?activityId=123&type=game&source=wechat&cuk=xxx&openId=xxx&...
```

## 自动添加的参数

小程序会自动在H5 URL中添加以下参数（无需手动传递）：

### 用户身份参数

| 参数名 | 说明 | 示例值 | 备注 |
|--------|------|--------|------|
| `cuk` | 用户登录凭证 | `abc123def456` | 自动添加（如果已登录） |
| `miniopenid` | 用户OpenID | `oXXX...` | 自动添加 |
| `unionId` | 用户UnionID | `uXXX...` | 自动添加（如果存在） |
| `wxNickName` | 微信昵称 | `张三` | 自动添加（如果存在） |

### 会员信息参数（仅已登录用户）

| 参数名 | 说明 | 示例值 | 备注 |
|--------|------|--------|------|
| `memberid` | 会员ID | `CRM000000000188501075` | 自动添加（已登录时） |
| `crmId` | 会员ID（同memberid） | `CRM000000000188501075` | 自动添加（已登录时） |
| `programLogin` | 是否登录 | `'1'` 或 `'0'` | `'1'`=已登录，`'0'`=未登录 |
| `memberType` | 会员等级名称 | `V1黄金会员` | 从 `gradeList` 中根据 `grade` 匹配获取 |

**会员等级说明**：
- `memberType` 的值来自接口返回的 `gradeList` 数组
- 根据当前用户的 `grade` 值，在 `gradeList` 中查找对应的 `gradeName`
- 如果找不到，则使用 `gradeName` 字段
- 如果都没有，则使用 `grade` 的字符串值

**示例数据**：
```json
{
  "grade": "0",
  "gradeList": [
    {"grade": "0", "gradeName": "V1黄金会员"},
    {"grade": "1", "gradeName": "V2铂金会员"},
    {"grade": "2", "gradeName": "V3钻石会员"}
  ]
}
```

如果用户的 `grade` 为 `"0"`，则 `memberType` 参数值为 `"V1黄金会员"`。

## 完整示例

### 示例1：基础跳转

```javascript
// 小程序代码
uni.navigateTo({
  url: '/pages/gameWebview/webview?url=https://example.com/h5/game'
})
```

**实际传递到H5的URL**：
```

```

### 示例2：带自定义参数和场景值

```javascript
// 小程序代码
uni.navigateTo({
  url: '/pages/gameWebview/webview?url=https://example.com/h5/activity&activityId=123&type=game&scene=' + encodeURIComponent(encodeURIComponent('?campaign=summer&source=qr'))
})
```

**说明**：
- `scene` 参数会被双重解码，所以需要双重编码
- 其他参数会原样传递

### 示例3：需要登录的页面

```javascript
// 小程序代码
uni.navigateTo({
  url: '/pages/gameWebview/webview?url=https://example.com/h5/member&needLogin=true'
})
```

**说明**：
- 如果 `needLogin=true` 且用户未登录，会自动跳转到注册页
- 注册成功后返回webview页面

### 示例4：使用相对路径

```javascript
// 小程序代码
uni.navigateTo({
  url: '/pages/gameWebview/webview?url=momclub-test.feihe.com/h5/game'
})
```

**说明**：
- 如果URL不包含协议，会自动添加 `https://`
- 实际URL：`https://momclub-test.feihe.com/h5/game`

## 参数编码说明

### 自动编码

所有参数值都会自动进行 `encodeURIComponent` 编码，无需手动编码。

### Scene参数特殊处理

`scene` 参数会被双重解码，所以如果需要传递 `scene` 参数，需要双重编码：

```javascript
const scene = '?campaign=summer&source=qr'
const encodedScene = encodeURIComponent(encodeURIComponent(scene))
uni.navigateTo({
  url: `/pages/gameWebview/webview?url=https://example.com/h5/page&scene=${encodedScene}`
})
```

## 在H5页面中获取参数

H5页面可以通过以下方式获取参数：

```javascript
// 方式1：使用 URLSearchParams
const urlParams = new URLSearchParams(window.location.search)
const activityId = urlParams.get('activityId')
const memberId = urlParams.get('memberId')
const programLogin = urlParams.get('programLogin')
const memberType = urlParams.get('memberType')

// 方式2：手动解析
function getQueryParam(name) {
  const urlParams = new URLSearchParams(window.location.search)
  return urlParams.get(name)
}

const memberId = getQueryParam('memberId')
```

## 注意事项

1. **参数长度限制**：URL总长度有限制，建议不要传递过多参数
2. **参数编码**：参数值会自动编码，无需手动处理
3. **登录状态**：`programLogin` 参数会自动根据用户登录状态设置
4. **会员信息**：会员相关参数（`memberId`、`memberType`）仅在用户已登录时添加
5. **Scene参数**：`scene` 参数会被特殊处理（双重解码），主要用于二维码场景
6. **默认URL**：如果未指定 `url` 或 `baseUrl`，会使用默认的测试环境URL

## 常见问题

### Q1: 如何判断用户是否登录？
A: 检查 `programLogin` 参数，值为 `'1'` 表示已登录，`'0'` 表示未登录。

### Q2: 如何获取会员等级？
A: 使用 `memberType` 参数，值为会员等级名称（如 `"V1黄金会员"`）。

### Q3: 如何传递复杂数据结构？
A: 建议将复杂数据序列化为JSON字符串传递，或通过接口获取。

### Q4: Scene参数如何使用？
A: `scene` 参数主要用于二维码场景，会自动双重解码，可以包含查询字符串格式的参数。

## 更新日志

- 2025-01-XX: 添加 `memberId`、`programLogin`、`memberType` 参数自动传递
- 2025-01-XX: `memberType` 改为从 `gradeList` 中获取 `gradeName`

