import requestModule from './request.js';
const {
	api
} = requestModule;

/**
 * 获取首页信息
 * @returns
 */
export const growthHome = (babyId) => api.post('/c/growth/home', { babyId });

export const guideCompleted = () => api.post('/c/growth/guide/Completed');

export const assessmentSave = (data) => api.post('/c/growth/assessment/save', data);

export const getGrowthCurveData = (babyData) => api.post('/c/growth/curve/data', babyData);

export const getGrowthHistoryList = () => api.post('/c/growth/history/list');

export const getGrowthAssessmentDetail = (assessmentId) => api.get('/c/growth/assessment/detail', { assessmentId });
// export const fetchHomeJSON = () => api.get('/c/front/content',{type:'home'});

/**
 * 获取生长工具配置信息
 * @returns
 */

export const fetchShengzhangToolsJSON = () => api.get('/c/front/content',{type:'shengzhang'});