import App from "./App";
// import apiRequest from "@/api/request.js";
import * as Pinia from "pinia";
import md from "./md";

const SENSORS_URL = "https://sensors.feihe.com/sa?project=XMH_Content";

// const BASE_URL = 'https://duiba.oss-cn-hangzhou.aliyuncs.com/fh/';
const BASE_URL = 'https://firmus-member-test-1253290912.cos.ap-beijing.myqcloud.com/xmh-mini-program/';
// const BASE_URL = "https://course.feihe.com/momclub-picture/";

md.init(SENSORS_URL);

// #ifndef VUE3
import Vue from "vue";
import "./uni.promisify.adaptor";

// 全局挂载后使用
// Vue.prototype.$api = apiRequest.api;
Vue.prototype.$baseUrl = BASE_URL;
Vue.prototype.$sensors = md.sensors;

Vue.config.productionTip = false;
App.mpType = "app";

const app = new Vue({
	...App,
});
app.$mount();
// #endif

// #ifdef VUE3
import {createSSRApp} from "vue";
import {useGlobalStore} from "@/stores/global";

export function createApp() {
	const app = createSSRApp(App);
	app.use(Pinia.createPinia());
	// app.config.globalProperties.$api = apiRequest.api;
	app.config.globalProperties.$baseUrl = BASE_URL;
	app.config.globalProperties.$sensors = md.sensors;

	useGlobalStore().setBaseUrl(BASE_URL)

	return {
		app,
		Pinia,
	};
}

// #endif
