# XingmaLab 弹窗组件库

这是一个弹窗组件库，包含多个弹窗组件，用于不同的业务场景。参考 `babyClass` 组件的实现方式，使用简洁的图片标签和样式结构。

## 组件列表

### 1. Xingmalabconfirmpop - 确认弹窗组件
用于显示确认对话框，支持确认和取消操作。

### 2. Xingmalabnotimepop - 无时间弹窗组件
用于显示无时间状态的弹窗，通常只有一个按钮。

## 功能特性

- 支持显示/隐藏控制
- 响应式设计
- 图片资源集中配置管理
- 支持版本控制和图片更新
- 统一的样式和交互规范
- 支持自定义文案和样式
- 参考 babyClass 组件的简洁实现方式

## 实现方式

### 背景遮罩实现
弹窗组件使用双层结构实现背景遮罩效果：

```vue
<template>
  <view class="xingmalabconfirmpop">
    <!-- 背景遮罩 -->
    <view class="mask"></view>
    
    <!-- 弹窗内容 -->
    <view class="popup-content">
      <!-- 弹窗图片和按钮 -->
    </view>
  </view>
</template>
```

### 遮罩样式
```less
.mask {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-color: rgba(0, 0, 0, 0.5);  // 半透明黑色背景
}

.popup-content {
  position: relative;
  z-index: 1;  // 确保内容在遮罩之上
}
```

### 图片标签使用
组件使用 `<image>` 标签而不是 `<span>` 标签，提供更好的图片显示效果：

```vue
<image 
  class="xingmalabconfirmpopbg" 
  :src="`${$baseUrl}${XINGMALAB_IMAGES.CONFIRM.BG}`" 
  mode="aspectFit"
></image>
```

### 图片配置管理
图片路径通过 `xingmalabImages.js` 文件集中管理：

```javascript
export const XINGMALAB_IMAGES = {
  CONFIRM: {
    BG: `XingmaLabPop/v1/XingmaLabConfirmPopBg.png`,
    CONFIRM_BTN: `XingmaLabPop/v1/XingmaLabConfirmPopConfirmBtn.png`,
    CANCEL_BTN: `XingmaLabPop/v1/XingmaLabCancelBtn.png`
  },
  NO_TIME: {
    BG: `XingmaLabPop/v1/XingmaLabNoTimePopBg.png`,
    BTN: `XingmaLabPop/v1/XingmaLabNoTimePopBtn.png`
  }
}
```

### 样式结构
使用简洁的 Less 样式，直接定义尺寸和位置：

```less
.xingmalabconfirmpop {
  width: 750rpx;
  height: 1624rpx;
  left: 0rpx;
  top: 0rpx;
  position: absolute;
  z-index: 9999;

  .xingmalabconfirmpopbg {
    width: 618rpx;
    height: 557rpx;
    left: 0rpx;
    top: 0rpx;
    position: absolute;
  }
}
```

## 使用方法

### Xingmalabconfirmpop 组件

```vue
<template>
  <view>
    <button @click="showConfirm = true">显示确认弹窗</button>
    
    <Xingmalabconfirmpop
      :visible="showConfirm"
      title="确认操作"
      confirm-text="确定"
      cancel-text="取消"
      @confirm="handleConfirm"
      @cancel="handleCancel"
      @close="showConfirm = false"
    />
  </view>
</template>

<script setup>
import { ref } from 'vue'
import Xingmalabconfirmpop from '@/components/xingmaLab/Xingmalabconfirmpop.vue'

const showConfirm = ref(false)

const handleConfirm = () => {
  console.log('用户点击了确认')
  showConfirm.value = false
}

const handleCancel = () => {
  console.log('用户点击了取消')
  showConfirm.value = false
}
</script>
```

### Xingmalabnotimepop 组件

```vue
<template>
  <view>
    <button @click="showNoTime = true">显示无时间弹窗</button>
    
    <Xingmalabnotimepop
      :visible="showNoTime"
      title="暂无时间"
      @button-click="handleButtonClick"
      @close="showNoTime = false"
    />
  </view>
</template>

<script setup>
import { ref } from 'vue'
import Xingmalabnotimepop from '@/components/xingmaLab/Xingmalabnotimepop.vue'

const showNoTime = ref(false)

const handleButtonClick = () => {
  console.log('用户点击了按钮')
  showNoTime.value = false
}
</script>
```

## 在发布页面中的使用

弹窗组件在 `XingmaLabPublishPage.vue` 中的使用示例：

```vue
<!-- 确认发布弹窗 -->
<Xingmalabconfirmpop
  :visible="showConfirmPopup"
  title="确认发布"
  confirm-text="确认发布"
  cancel-text="取消"
  @confirm="handleConfirmPublish"
  @cancel="handleCancelPublish"
  @close="showConfirmPopup = false"
/>

<!-- 无次数弹窗 -->
<Xingmalabnotimepop
  :visible="showNoTimePopup"
  title="发布次数已用完"
  @button-click="handleNoTimeButtonClick"
  @close="showNoTimePopup = false"
/>
```

## Props

### Xingmalabconfirmpop Props

| 属性名 | 类型 | 默认值 | 说明 |
|--------|------|--------|------|
| visible | Boolean | false | 控制弹窗显示/隐藏 |
| title | String | '确认' | 弹窗标题 |
| confirmText | String | '确认' | 确认按钮文本 |
| cancelText | String | '取消' | 取消按钮文本 |

### Xingmalabnotimepop Props

| 属性名 | 类型 | 默认值 | 说明 |
|--------|------|--------|------|
| visible | Boolean | false | 控制弹窗显示/隐藏 |
| title | String | '暂无时间' | 弹窗标题 |

## Events

### Xingmalabconfirmpop Events

| 事件名 | 说明 | 回调参数 |
|--------|------|----------|
| confirm | 点击确认按钮时触发 | - |
| cancel | 点击取消按钮时触发 | - |
| close | 点击遮罩层时触发 | - |

### Xingmalabnotimepop Events

| 事件名 | 说明 | 回调参数 |
|--------|------|----------|
| button-click | 点击按钮时触发 | - |
| close | 点击遮罩层时触发 | - |

## 图片配置

组件使用集中化的图片配置管理，所有图片路径都在 `xingmalabImages.js` 文件中配置：

```javascript
// 确认弹窗图片配置
CONFIRM: {
  BG: `XingmaLabPop/v1/XingmaLabConfirmPopBg.png`,
  CONFIRM_BTN: `XingmaLabPop/v1/XingmaLabConfirmPopConfirmBtn.png`,
  CANCEL_BTN: `XingmaLabPop/v1/XingmaLabCancelBtn.png`
}

// 无时间弹窗图片配置
NO_TIME: {
  BG: `XingmaLabPop/v1/XingmaLabNoTimePopBg.png`,
  BTN: `XingmaLabPop/v1/XingmaLabNoTimePopBtn.png`
}
```

### 图片目录结构

```
static/
└── XingmaLabPop/
    └── v1/
        ├── XingmaLabConfirmPopBg.png          # 确认弹窗背景
        ├── XingmaLabConfirmPopConfirmBtn.png  # 确认弹窗确认按钮
        ├── XingmaLabCancelBtn.png             # 确认弹窗取消按钮
        ├── XingmaLabNoTimePopBg.png           # 无时间弹窗背景
        └── XingmaLabNoTimePopBtn.png          # 无时间弹窗按钮
```

## 按钮位置配置

### 与React版本对比

为了确保Vue组件与原始React组件完全一致，按钮位置配置如下：

#### Xingmalabconfirmpop 按钮位置
| 按钮 | React版本 (px) | Vue版本 (rpx) | 说明 |
|------|----------------|---------------|------|
| 确认按钮 | left: 318, top: 408 | left: 318, top: 408 | 完全一致 |
| 取消按钮 | left: 28, top: 406 | left: 28, top: 406 | 完全一致 |

#### Xingmalabnotimepop 按钮位置
| 按钮 | React版本 (px) | Vue版本 (rpx) | 说明 |
|------|----------------|---------------|------|
| 按钮 | left: 76, top: 312 | left: 76, top: 312 | 完全一致 |

### 定位方式
- **React版本**: 使用 `position: absolute` 和固定的 `left`、`top` 值
- **Vue版本**: 使用 `position: absolute` 和相同的 `left`、`top` 值
- **单位转换**: React使用 `px`，Vue使用 `rpx`，但数值保持一致

### 尺寸配置
- **弹窗容器**: 750rpx × 1624rpx (与React的750px × 1624px对应)
- **背景图片**: 618rpx × 557rpx (确认弹窗) / 618rpx × 460rpx (无时间弹窗)
- **按钮尺寸**: 与React版本完全一致

## 样式配置

```javascript
// 按钮交互效果
transition: transform 0.2s ease;

&:active {
  transform: scale(0.95);
}
```

## 版本控制

组件支持版本控制，通过修改 `xingmalabImages.js` 中的 `version` 变量来管理不同版本的图片资源：

```javascript
const version = 'v1'  // 当前版本
```

## 与 babyClass 组件的对比

### 相似点
1. **图片标签使用**: 都使用 `<image>` 标签
2. **图片配置管理**: 都使用独立的图片配置文件
3. **样式结构**: 都使用简洁的 Less 样式
4. **版本控制**: 都支持版本管理

### 不同点
1. **业务逻辑**: babyClass 处理等级展示，xingmalab 处理弹窗交互
2. **图片数量**: babyClass 有多个等级图片，xingmalab 只有弹窗图片
3. **交互方式**: babyClass 主要是展示，xingmalab 主要是交互

## 注意事项

1. **图片资源**: 需要准备对应的背景图片文件并放置在正确的目录结构中
2. **样式单位**: 组件使用 rpx 单位，确保跨平台兼容性
3. **事件处理**: 组件会发射标准事件，父组件可以监听处理
4. **配置管理**: 所有图片路径都在 `xingmalabImages.js` 中集中管理
5. **版本更新**: 如需更新图片，只需替换文件并更新版本号即可
6. **组件复用**: 多个弹窗组件共享相同的配置管理机制
7. **发布流程**: 在发布页面中，弹窗组件用于二次确认和次数限制提示
8. **实现方式**: 参考 babyClass 组件的简洁实现，使用 image 标签和直接样式

## 文件结构

```
components/xingmaLab/
├── Xingmalabconfirmpop.vue    # 确认弹窗组件
├── Xingmalabnotimepop.vue     # 无时间弹窗组件
├── xingmalabImages.js         # 图片配置文件
├── mock-configs.js                   # 旧版配置文件（已废弃）
├── README.md                   # 使用说明
└── IMAGES.md                   # 图片资源说明
```

## 迁移说明

从旧版配置系统迁移到新的图片配置系统：

1. **移除依赖**: 不再依赖 `mock-configs.js` 中的复杂配置
2. **简化导入**: 直接导入 `XINGMALAB_IMAGES` 常量
3. **简化样式**: 移除计算属性，直接使用 CSS 样式
4. **保持兼容**: 按钮位置和尺寸与 React 版本完全一致
