import requestModule from './request.js';
const {
    api
} = requestModule;

/**
 * 获取首页信息
 * @returns
 * {
  * 返回值
 timestamp	number	
非必须
当前服务器时间戳	
lastRecordType	number	
非必须
上次喂养方式：喂养方式:0-无记录 1-母乳亲喂, 2-母乳瓶喂, 3-奶粉喂养, 4-辅食	
lastBreastMilkVolume	number	
非必须
上次母乳瓶喂喂养量(lastRecordType=2时有值)	
lastFormulaVolume	number	
非必须
上次奶粉瓶喂喂养量(lastRecordType=3时有值)	
leftTimerRunning	boolean	
非必须
左边计时器是否在进行	
leftTimerDuration	number	
非必须
有正在进行中的母乳喂养计时器：左侧累计时长(ms)	
rightTimerRunning	boolean	
非必须
右边计时器是否在进行	
rightTimerDuration	number	
非必须
有正在进行中的母乳喂养计时器：右侧累计时长(ms)
}
 */
export const feedingHome = (babyId) => api.get('/c/feeding/home', { babyId });


/**
 * 
 * @param {*} recordId 
 * @param {*} babyId 
 * @param {*} recordTime 
 * @param {*} feedingType 
 * @param {*} durationLeftSeconds 
 * @param {*} durationRightSeconds 
 * @param {*} totalDurationSeconds 
 * @param {*} volume 
 * @param {*} foodDetails 
 * @returns 
 */
export const feedingRecords = (data) => api.post('/c/feeding/records', {
    recordId:data.recordId,
    babyId:data.babyId,
    recordTime:data.recordTime,
    feedingType:data.feedingType,//1-母乳亲喂, 2-母乳瓶喂, 3-奶粉喂养, 4-辅食	
    durationLeftSeconds:data.durationLeftSeconds,//左侧喂养时长(秒)	
    durationRightSeconds:data.durationRightSeconds,//右侧喂养时长(秒)	
    totalDurationSeconds:data.totalDurationSeconds,//总时长(秒), 手动记录时使用	
    volume:data.volume,//容量(ml)	
    foodDetails:data.foodDetails//辅食详情
});


// 根据宝宝ID和指定日期（格式：YYYY-MM-DD）获取当天的所有喂养记录。
export const feedingRecordsByDate = (data) => api.get('/c/feeding/records', {
    babyId:data.babyId,
    date:data.date
});

// 获取喂养记录的日历状态
export const feedingRecordsCalendarStatus = (data) => api.get('/c/feeding/records/calendar-status', {
    babyId:data.babyId,
    month:data.month
});

// 获取喂养记录的统计信息
export const feedingRecordsStatisticsPeriod = (data) => api.get('/c/feeding/statistics/period', {
    babyId:data.babyId,
    sdate:data.sdate,
    edate:data.edate
});

// 获取自定义辅食
/**
 * 
 * @param {*} data 
 * @returns 
 * foodId	integer	
非必须
辅食ID	
format: int64

foodName	string	
非必须
辅食名称	
foodType	number	
必须
1-主食 2-蔬菜 3-水果 4-其它
 */
export const feedingFoodsCustom = (data) => api.get('/c/feeding/foods/custom');

// 添加自定义辅食
export const feedingFoodsCustomAdd = (data) => api.post('/c/feeding/foods/custom/add', {
    foodName:data.foodName,
    foodType:data.foodType
});

// 删除自定义辅食
export const feedingFoodsCustomDelete = (data) => api.post('/c/feeding/foods/custom/delete', {
    foodIds:data.foodIds,//多个ID，逗号分隔	
});

// 开始计时
export const feedingTimerStart = (data) => api.post('/c/feeding/timer/start', {
    babyId:data.babyId,
    side:data.side
});


export const feedingTimerStop = (data) => api.post('/c/feeding/timer/stop', {
    babyId:data.babyId,
    side:data.side
});

// 上传语音
/**
 * 
 * @param {*} data 
 * @returns 
 * taskId
 **/
export const feedingVoiceUpload = (data) => api.post('/c/feeding/voice/upload', {
    audioData:data.audioData,//base64
});


// 获取语音识别结果
export const feedingVoiceResult = (data) => api.get('/c/feeding/voice/result', {
    taskId:data.taskId,
});



// 删除自定义辅食



// export const fetchHomeJSON = () => api.get('/c/front/content',{type:'home'});