import requestModule from '@/api/request.js'
const {api} = requestModule
import {homeConfig} from "./mock-configs";
import {InvitationInfo, CodeResponse} from "@/activities/1015/types";

/**
 * 获取页面配置
 * @returns
 */
export function fetchPageConfig() {
	/*return Promise.resolve({
		data: homeConfig(),
	})*/
	return api.get('/c/front/content', {type: 'act1015',version: '1'})
}

/**
 * 获取抽奖配置
 * @returns
 */
export function fetchLotteryConfig (){
	return api.get('/c/front/content', {type: 'act915Lottery',version: '1'})
}

/**
 * 获取邀请助力组件信息
 * @returns
 */
export function fetchInvitationInfo (){
	return api.post('/c/activity/use_invite_101/invitation/home') as Promise<CodeResponse<InvitationInfo>>
}

/**
 * 邀请助力
 * @returns
 */
export function invitationAssist(inviterUserId, unionId) {
	return api.post('/c/activity/use_invite_101/invitation/assist', {invitationCode: inviterUserId, wxUnionId: unionId})
}

/**
 * 获取抽奖信息
 * @returns
 */
export function fetchLotteryInfo (){
	return api.get('/c/activity/turntable_lottery_101/home')
}

/**
 * 抽奖
 * @returns
 */
export function lotteryDraw (){
	return api.post('/c/activity/turntable_lottery_101/lottery/draw')
}
